*-------------------------------------------------------------------------------
/* title : Estimation results for Online Appendix
   input : $temp/Sample.dta and 
		   $temp/Sample_lag_proxies.dta --- used for additonal variables
   output: $output_dta/ .dta files store bootstrap point estimates 
		   $output_dta/ .ster files store estimation results */
*-------------------------------------------------------------------------------

*===============================================================================
* Set up
*===============================================================================
*--------------------------SET-UP & READ DIRECTORIES----------------------------
cd							// Current directory of code
run "[0.0] directories.do" 	// Load directories

*-----------------------------MACROS FOR ESTIMATION-----------------------------
global compet	PC			// Competition in output market: Perfect (PC); Imperfect (IC)
global inputs	PkPl		// Timing assumption for inputs: PkPl(default)=Pre-determined k & Pre-determined l; PkDl=Pre-determined k & Dynamic l; or PkFl=Pre-determined k & Flexible l

*-----------------------MACROS FOR INSTRUMENTAL VARIABLES-----------------------
global IVext   NO			// YES includes external instruments (defined in the macro Instruments); NO (default) use own variable lags to instrument

*-------------------------------MACROS FOR DATA---------------------------------
global indlev	CPA			// Industry classification: CPA (ISIC Rev.4 also in WIOD); nace2 (nace rev.2 2-digit); A38(intermediate aggregation of nace)

*-----------------------------MACROS FOR BOOTSTRAP------------------------------
global seed 	1658203945 	// Set random-# seed for replicability of results
global B		99 			// Bootstrap replications: Efron&Tibsharani(1993) B=200 almost always enough; Davidson&MacKinnon(2002) for a=0.05->B=399 & for a=0.01->B=1499; (Cameron & Trivedi pg.361-362; a(B+1)=integer)
global clust	Ccj			// Variables identifying resampling clusters for bootstraping: id; $indlev country; Cc; Cj; Ccj
global idclust	newCcj 		// Creates a new variable containing a unique identifier for each resampled cluster: newid; newCc; newCj; newCcj
global group	newid 		// Re-creates varname with a unique identifier for each firm across the resampled clusters (including re-sampling the same original cluster): newid

*-------------------------MACROS FOR FIXED-EFFECTS (FE)-------------------------
global FEj 		YES			// Industry: YES or NO
global FEc 		YES			// Country: YES or NO
global FEt 		YES			// Time: YES or NO
global FEjt 	NO			// Industry-time: YES or NO
global FEct 	NO			// Country-time: YES or NO

*-------------------------MACROS FOR LINEAR TIME TRENDS-------------------------
global TREND 	NO			// Time: YES or NO
global TRENDj 	YES			// Industry: YES or NO
global TRENDc 	YES			// Country: YES or NO

*-------------------------------------------------------------------------------

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* No Intra-Industry proxies - Table D.3; column (2)
*===============================================================================
global model NoII 						// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_Bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Only Downstream Importing and Intra-Industry proxies - Table D.3; column (3)
*===============================================================================
global model down0dIM 					// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *up0dEX *up0dIM *down0dEX 

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov $model IM EX shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Only Upstream Exporting and Intra-Industry proxies - Table D.3; column (4)
*===============================================================================
global model up0dEX 					// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dIM *down0dEX 

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov $model IM EX shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Only Upstream Importing and Intra-Industry proxies - Table D.3; column (5)
*===============================================================================
global model up0dIM 					// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX *down0dEX 

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov $model IM EX shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Only Downstream Exporting and Intra-Industry proxies - Table D.3; column (6)
*===============================================================================
global model down0dEX 					// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX *up0dIM 

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov $model IM EX shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Only Downstream Importing & No Intra-Industry proxies - Table D.3; column (7)
*===============================================================================
local proxy down0dIM
global model `proxy'_NoII 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *up0dEX *up0dIM *down0dEX 

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov `proxy' shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Only Upstream Exporting & No Intra-Industry proxies - Table D.3; column (8)
*===============================================================================
local proxy up0dEX
global model `proxy'_NoII 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dIM *down0dEX 

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov `proxy' shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Only Upstream Importing & No Intra-Industry proxies - Table D.3; column (9)
*===============================================================================
local proxy up0dIM
global model `proxy'_NoII 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX *down0dEX 

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov `proxy' shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Only Downstream Exporting & No Intra-Industry proxies - Table D.3; column (10)
*===============================================================================
local proxy down0dEX
global model `proxy'_NoII 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX *up0dIM 

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov `proxy' shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Proxies including 0 diagonal (0d) - Table D.4; column (2)
*===============================================================================
global model 	ProxiesWith0d 			// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX *up0dIM *down0dEX
merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*downIM *upEX *upIM *downEX)

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov downIM upEX upIM downEX IM EX shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for // Declare key regressors of interest in markov process (excluding persistence term and fixed effects)

*===============================================================================
* Proxies down0dIM & up0dEX with broad industries & 0d - Table D.4; column (3)
*===============================================================================
global model 	Proxies0dBroad 			// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX
merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*down0dIMbroad *up0dEXbroad)

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIMbroad up0dEXbroad up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for // Declare key regressors of interest in markov process (excluding persistence term and fixed effects)

*===============================================================================
* Size < 50 employees - Table D.4; column (4)
*===============================================================================
global model 	SizeSmall 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Keep small-sized enterprises: http://ec.europa.eu/growth/smes/business-friendly-environment/sme-definition_en
gegen avgL = mean(L), by(newid)
gegen avgOPREV = mean(OPREV), by(newid)
keep if avgL<50 & avgOPREV<=10000000

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Size >= 50 employees - Table D.4; column (5)
*===============================================================================
global model 	SizeLarge				// Name of estimation (also used to save results)
use "$temp/Sample.dta", clear

* Drop small-sized enterprises: http://ec.europa.eu/growth/smes/business-friendly-environment/sme-definition_en
gegen avgL = mean(L), by(newid)
gegen avgOPREV = mean(OPREV), by(newid)
drop if avgL<50 & avgOPREV<=10000000

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Size: Interact Proxies with size dummy - Table D.4; column (6)
*===============================================================================
global model 	Size_D 					// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Define small-sized firms: http://ec.europa.eu/growth/smes/business-friendly-environment/sme-definition_en
gegen avgL = mean(L), by(newid)
gegen avgOPREV = mean(OPREV), by(newid)

gen D = 0
replace D = 1 if avgL<50 & avgOPREV<=10000000 // Small-sized firms

* Generate relevant lags of interactions terms (note: D is time-invariant)
xtset newid year
foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX {
	* Lags
	qui forvalues i = 1/2 {
		gen L`i'_`var'_D = L`i'_`var'*D 
	}
	
	* First-differences
	qui forvalues i = 1/12 {
		 gen DL`i'_`var'_D = DL`i'_`var'*D
	}
}

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Trim outliers at the (1-.15)% BACON cuttoff - Table D.4; column (8)
*===============================================================================
global model 	Bacon15					// Name of estimation (also used to save results)

use "$temp/Sample15.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Bootstrap with 499 replications - Table D.4; column (9)
*===============================================================================
global model 	Bootstraps	 			// Name of estimation (also used to save results)
global B		499 					// Bootstrap replications

use "$temp/Sample.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global B		99 						// Bootstrap replications

*===============================================================================
* Industry-j-level clustering - Table D.4; column (9)
*===============================================================================
global model 	Cluster_j	 			// Name of estimation (also used to save results)
global clust	Cj						// Variables identifying resampling clusters for bootstraping: id; $indlev country; Cc; Cj; Ccj
global idclust	$indlev 				// Creates a new variable containing a unique identifier for each resampled cluster: newid; newCc; newCj; newCcj

use "$temp/Sample.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global clust	Ccj						// Variables identifying resampling clusters for bootstraping: id; $indlev country; Cc; Cj; Ccj
global idclust	newCcj 					// Creates a new variable containing a unique identifier for each resampled cluster: newid; newCc; newCj; newCcj


*===============================================================================
* Country-c-level clustering - Table D.4; column (10)
*===============================================================================
global model 	Cluster_i	 			// Name of estimation (also used to save results)
global clust	id						// Variables identifying resampling clusters for bootstraping: id; $indlev country; Cc; Cj; Ccj
global idclust	newid 					// Creates a new variable containing a unique identifier for each resampled cluster: newid; newCc; newCj; newCcj

use "$temp/Sample.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global clust	Ccj						// Variables identifying resampling clusters for bootstraping: id; $indlev country; Cc; Cj; Ccj
global idclust	newCcj 					// Creates a new variable containing a unique identifier for each resampled cluster: newid; newCc; newCj; newCcj

*===============================================================================
* Firm-i-level clustering - Table D.4; column (11)
*===============================================================================
global model 	Cluster_c	 			// Name of estimation (also used to save results)
global clust	Cc						// Variables identifying resampling clusters for bootstraping: id; $indlev country; Cc; Cj; Ccj
global idclust	newCc 					// Creates a new variable containing a unique identifier for each resampled cluster: newid; newCc; newCj; newCcj

use "$temp/Sample.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global clust	Ccj						// Variables identifying resampling clusters for bootstraping: id; $indlev country; Cc; Cj; Ccj
global idclust	newCcj 					// Creates a new variable containing a unique identifier for each resampled cluster: newid; newCc; newCj; newCcj

*===============================================================================
* Firms with domestic but no foreign ownership links - Table D.5; column (2)
*===============================================================================
global model 	DomesticLinks 			// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Firms with domestic but no foreign ownership links
replace sub_for=0 if sub_dom==1 | shh_dom==1
replace shh_for=0 if sub_dom==1 | shh_dom==1
drop if sub_for==1 | shh_for==1 		// Drop firms with only foreign ownership

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Foreign owned firms with no domestic ownership links - Table D.5; column (3)
*===============================================================================
global model 	NoDomesticLinks 		// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Foreign owned firms with no domestic ownership links
drop if sub_dom==1 | shh_dom==1 		// Drop firms with domestic ownership
keep if sub_for==1 | shh_for==1 		// Keep firms with foreign ownership

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Relatively Downstream - Table D.5; column (4)
*===============================================================================
global model 	Downstream 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Keep relatively downstream industries
keep if inlist(CPA, 12, 22, 21, 17, 20, 6, 5, 19, 18)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively Upstream - Table D.5; column (5)
*===============================================================================
global model 	Upstream 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Drop relatively downstream industries
drop if inlist(CPA, 12, 22, 21, 17, 20, 6, 5, 19, 18)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively Low-tech - Table D.5; column (6)
*===============================================================================
global model 	LowTech 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Drop relatively high-medium-tech industries
* See High&Medium-High&Medium-Low-Tech industries in: http://ec.europa.eu/eurostat/statistics-explained/index.php?title=Glossary:High-tech
drop if inlist(CPA, 12, 17, 11, 18, 19, 20, 21, 10, 13, 14, 15, 16, 23)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively High-medium-tech - Table D.5; column (7)
*===============================================================================
global model 	HighTech 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Keep relatively high-medium-tech industries
* See High&Medium-High&Medium-Low-Tech industries in: http://ec.europa.eu/eurostat/statistics-explained/index.php?title=Glossary:High-tech
keep if inlist(CPA, 12, 17, 11, 18, 19, 20, 21, 10, 13, 14, 15, 16, 23)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively Labour-intensive - Table D.5; column (8)
*===============================================================================
global model 	L 						// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Keep relatively labour industries
keep if inlist(CPA, 5, 6, 7, 9, 15, 16, 21, 22, 23)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively Capital-intensive - Table D.5; column (9)
*===============================================================================
global model 	K 						// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Drop relatively labour industries
drop if inlist(CPA, 5, 6, 7, 9, 15, 16, 21, 22, 23)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively Downstream & Low-tech - Table D.5; column (10)
*===============================================================================
global model 	DownstreamLowTech 		// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Keep relatively downstream and low-tech industries
keep if inlist(CPA, 12, 22, 21, 17, 20, 6, 5, 19, 18)
drop if inlist(CPA, 12, 17, 11, 18, 19, 20, 21, 10, 13, 14, 15, 16, 23)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively Downstream & High-medium-tech - Table D.5; column (11)
*===============================================================================
global model 	DownstreamHighTech 		// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Keep relatively downstream and high-medium-tech industries
keep if inlist(CPA, 12, 22, 21, 17, 20, 6, 5, 19, 18)
keep if inlist(CPA, 12, 17, 11, 18, 19, 20, 21, 10, 13, 14, 15, 16, 23)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively Downstream & Labour intensive - Table D.5; column (12)
*===============================================================================
global model 	DownstreamLowTech 		// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Keep relatively downstream and labour intensive industries
keep if inlist(CPA, 12, 22, 21, 17, 20, 6, 5, 19, 18)
drop if inlist(CPA, 8, 10, 11, 12, 13, 14, 17, 18, 19, 20)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively Downstream & Capital intensive - Table D.5; column (13)
*===============================================================================
global model 	DownstreamHighTech 		// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Keep relatively downstream and capital intensive industries
keep if inlist(CPA, 12, 22, 21, 17, 20, 6, 5, 19, 18)
keep if inlist(CPA, 8, 10, 11, 12, 13, 14, 17, 18, 19, 20)

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Relatively Low-tech in CEEC - Table D.6; column (2)
*===============================================================================
global model 	LowTech_D_CEEC 			// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Keep CEEC countries
keep if inlist(country, "BG", "CZ", "EE", "HR", "HU", "PL", "RO", "SI", "SK")

* Define relatively low-tech industries
* See High&Medium-High&Medium-Low-Tech industries in: http://ec.europa.eu/eurostat/statistics-explained/index.php?title=Glossary:High-tech
gen D = 1
replace D = 0 if inlist(CPA, 12, 17, 11, 18, 19, 20, 21, 10, 13, 14, 15, 16, 23)

* Generate relevant lags of interactions terms (note: D is time-invariant)
xtset newid year
foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX {
	* Lags
	qui forvalues i = 1/2 {
		gen L`i'_`var'_D = L`i'_`var'*D 
	}
	
	* First-differences
	qui forvalues i = 1/12 {
		 gen DL`i'_`var'_D = DL`i'_`var'*D
	}
}

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Relatively Low-tech in WEC - Table D.6; column (3)
*===============================================================================
global model 	LowTech_D_WEC 			// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Drop CEEC countries
drop if inlist(country, "BG", "CZ", "EE", "HR", "HU", "PL", "RO", "SI", "SK")

* Define relatively low-tech industries
* See High&Medium-High&Medium-Low-Tech industries in: http://ec.europa.eu/eurostat/statistics-explained/index.php?title=Glossary:High-tech
gen D = 1
replace D = 0 if inlist(CPA, 12, 17, 11, 18, 19, 20, 21, 10, 13, 14, 15, 16, 23)

* Generate relevant lags of interactions terms (note: D is time-invariant)
xtset newid year
foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX {
	* Lags
	qui forvalues i = 1/2 {
		gen L`i'_`var'_D = L`i'_`var'*D 
	}
	
	* First-differences
	qui forvalues i = 1/12 {
		 gen DL`i'_`var'_D = DL`i'_`var'*D
	}
}

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for
